Ext.data.JsonP.sol_common_ix_functions_FillSord({"tagname":"class","name":"sol.common.ix.functions.FillSord","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.FillSord.js","href":"sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord"}],"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloix":true,"requires":["sol.common.IxUtils","sol.common.JsonUtils","sol.common.ObjectUtils","sol.common.RepoUtils","sol.common.SordUtils","sol.common.Template","sol.common.Template","sol.common.WfUtils","sol.common.ix.FunctionBase","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"metadataMapping","tagname":"cfg","owner":"sol.common.ix.functions.FillSord","id":"cfg-metadataMapping","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.FunctionBase","id":"cfg-objId","meta":{}},{"name":"options","tagname":"cfg","owner":"sol.common.ix.functions.FillSord","id":"cfg-options","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"source","tagname":"cfg","owner":"sol.common.ix.functions.FillSord","id":"cfg-source","meta":{}},{"name":"target","tagname":"cfg","owner":"sol.common.ix.functions.FillSord","id":"cfg-target","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"_setParams","tagname":"property","owner":"sol.common.ix.functions.FillSord","id":"property-_setParams","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"determineTarget","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"method-determineTarget","meta":{"private":true}},{"name":"finalizeGeneratorParams","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"method-finalizeGeneratorParams","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"method-initialize","meta":{"private":true}},{"name":"parseOptions","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"method-parseOptions","meta":{"private":true}},{"name":"pepareSetParams","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"method-pepareSetParams","meta":{"private":true}},{"name":"prepareSource","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"method-prepareSource","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"method-process","meta":{"abstract":true}},{"name":"startWorkflowOn","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"method-startWorkflowOn","meta":{"private":true}},{"name":"storeResult","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"method-storeResult","meta":{"private":true}},{"name":"RF_sol_function_FillSord","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"static-method-RF_sol_function_FillSord","meta":{"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.FillSord","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.FillSord","short_doc":"Fills a sord with data using another sord, pulled by objId/flowId or predefined templateSord. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.FillSord</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord' target='_blank'>sol.common.ix.functions.FillSord.js</a></div></pre><div class='doc-contents'><p>Fills a sord with data using another sord, pulled by objId/flowId or predefined templateSord.\nReturns the objId (and flowId, if a workflow has been started) of the created element which has been written to.</p>\n\n<p>This function can be used in conjunction with <a href=\"#!/api/sol.common.ix.functions.CreateSord\" rel=\"sol.common.ix.functions.CreateSord\" class=\"docClass\">CreateSord</a>, which\ncan be used to create a sord. This means, you can create a sord and fill it with data all in one step if you\nuse the CreateSord RF as the <code>target</code>-service</p>\n\n<h3>Filling a sord using an objId</h3>\n\n<p>Writing all fields from one sord to another\n    {\n      source: { objId: \"12341\" },\n      target: { objId: \"64432\" }\n    }</p>\n\n<p>To only write specific fields, add the following:</p>\n\n<pre><code>{\n  source: { objId: \"12341\" },\n  metadataMapping: [\n    { source: { id: \"MY_FIELD\", type: \"GRP\" }, target: { id: \"MY_FIELDB\", type: \"GRP\" } },\n    { source: { id: \"MY_MAPFIELD\", type: \"MAP\" }, target: { id: \"MY_MAPFIELD\", type: \"MAP\" } }\n  ],\n  options: { onlyWriteMappings: true },\n  target: { objId: \"64432\" }\n}\n</code></pre>\n\n<h3>Starting a workflow on target after all fields have been written</h3>\n\n<p>If you'd like to start a workflow on the target sord after all fields have been written,\ndefine the following</p>\n\n<pre><code>{\n  source: { objId: \"12341\" },\n  target: {\n    objId: \"64432\",\n    startWorkflow: {\n      name: \"sol.mysolution.Caniddate.CreateHeadless\",\n      title: \"sol.wf.localization.message\",\n      concluding: true\n    }\n  }\n}\n</code></pre>\n\n<h3>Starting a workflow on target before writing metadata</h3>\n\n<p>If you'd like to start a workflow on the target sord before the data\nis being written to it (e.g. if setting WF-fields is required),\nyou can omit the \"concluding\" option from the <code>startWorkflow</code> definition.</p>\n\n<p>Attention! Fields will then be written concurrently to the started/running workflow.\nThis means, that the workflow must start with a user-node.\nOtherwise, the workflow might be over, before FillSords can write anything\nto the sord.</p>\n\n<h3>Examples</h3>\n\n<h3>Create a sord from another sord, templateSord as data source, mandatory field and workflow</h3>\n\n<h4>Arguments</h4>\n\n<pre><code>{\n  \"source\": {\n    \"templateSord\": {\n      \"mapKeys\": {\n        \"RECRUITING_CANDIDATE_PRIVATEEMAIL\": \"es@elo.com\",\n        \"RECRUITING_CANDIDATE_PRIVATEPHONE\": \"0711071133\"\n      },\n      \"objKeys\": {\n        \"RECRUITING_CANDIDATE_FIRSTNAME\": \"Max\",\n        \"RECRUITING_CANDIDATE_LASTNAME\": \"Mustermann\",\n        \"RECRUITING_CANDIDATE_CITY\": \"Stuttgart\"\n      }\n    }\n  },\n  \"target\": {\n    \"fromService\": {\n      \"name\": \"RF_sol_function_CreateSord\",\n      \"params\": {\n        \"sourceElement\": {\n          \"options\": {\n            \"copySourceAcl\": true\n          },\n          \"objId\": \"3674\"\n        },\n        \"targetFolder\": {\n          \"objId\": \"0\"\n        },\n        \"onCreatedElement\": {}\n      }\n    },\n    \"startWorkflow\": {\n      \"name\": \"sol.mysolution.Candidate.CreateHeadless\",\n      \"title\": \"sol.wf.localization.message\",\n      \"concluding\": true\n    }\n  },\n  \"options\": {\n    \"mandatoryFields\": [\n      {\n        \"type\": \"GRP\",\n        \"id\": \"RECRUITING_CANDIDATE_LASTNAME\"\n      }\n    ]\n  }\n}\n</code></pre>\n\n<h4>Return value</h4>\n\n<pre><code>{\n  objId: \"3982\",\n  flowId: \"89\"\n}\n</code></pre>\n\n<h3>Create a sord from scratch, use the sord active in a workflow as data source, start a workflow</h3>\n\n<h4>Arguments</h4>\n\n<pre><code>{\n  \"source\": {\n    \"objId\": \"fromParams\",\n    \"flowId\": \"fromParams\"\n  },\n  \"target\": {\n    \"fromService\": {\n      \"name\": \"RF_sol_function_CreateSord\",\n      \"params\": {\n        \"sourceElement\": { \"fromScratch\": { \"mask\": \"My Keywording Form\", \"type\": \"MyType\" } }\n      }\n    },\n    \"startWorkflow\": {\n      \"name\": \"sol.mysolution.Candidate.DoSomething\",\n      \"title\": \"sol.wf.localization.message\",\n      \"concluding\": true\n    }\n  },\n  \"metadataMapping\": [\n    { \"source\": { \"id\": \"MY_FIELD\", \"type\": \"GRP\" }, \"target\": { \"id\": \"MY_FIELDB\", \"type\": \"GRP\" } },\n    { \"source\": { \"id\": \"MY_MAPFIELD\", \"type\": \"MAP\" }, \"target\": { \"id\": \"MY_MAPFIELD\", \"type\": \"MAP\" } }\n  ],\n  \"options\": { \"onlyWriteMappings\": true }\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-metadataMapping' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-cfg-metadataMapping' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-cfg-metadataMapping' class='name expandable'>metadataMapping</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) if any fields from the data-source should be mapped to a different field/value (see GetSetInstructions ...</div><div class='long'><p>(optional) if any fields from the data-source should be mapped to a different field/value (see GetSetInstructions</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>(optional)</p>\n<ul><li><span class='pre'>id</span> : String<div class='sub-desc'><p>name of source field</p>\n</div></li><li><span class='pre'>type</span> : String|\"GRP\"|\"MAP\"|\"WFMAP\"|\"FORMBLOB\"<div class='sub-desc'><p>type of field</p>\n</div></li></ul></div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'><p>(optional)</p>\n<ul><li><span class='pre'>id</span> : String<div class='sub-desc'><p>name of target field</p>\n</div></li><li><span class='pre'>type</span> : String|\"GRP\"|\"MAP\"|\"WFMAP\"|\"FORMBLOB\"<div class='sub-desc'><p>type of field</p>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'><p>(optional) fixed or template String. This is completely optional!</p>\n</div></li></ul></div></li></ul></div></li></ul></div></div></div><div id='cfg-objId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-options' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-cfg-options' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-cfg-options' class='name expandable'>options</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<ul><li><span class='pre'>reverseSourceAndTarget</span> : Boolean (optional)<div class='sub-desc'><p>(optional) switches <code>source</code> and <code>target</code> definitions</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>reverseMetadataMapping</span> : Boolean (optional)<div class='sub-desc'><p>(optional) switches <code>source</code> and <code>target</code> definitions inside the <code>metadataMapping</code></p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>escapeHTML</span> : Boolean (optional)<div class='sub-desc'><p>(optional) if true, HTML characters will be escaped</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>onlyWriteMappings</span> : Boolean (optional)<div class='sub-desc'><p>(optional) only fields defined in the <code>metadataMapping</code> will be set on the target.</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>emptyNonRenderedTemplates</span> : Boolean (optional)<div class='sub-desc'><p>(optional) empty set-value if handlebars could not render template</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>protectedFields</span> : Object[]<div class='sub-desc'><p>(optional) any fields which will not be written, even if they appear in the mapping or templateSord (see GetSetInstructions</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>id</span> : String<div class='sub-desc'><p>name of the protected field</p>\n</div></li><li><span class='pre'>type</span> : String|\"GRP\"|\"MAP\"|\"WFMAP\"|\"FORMBLOB\"<div class='sub-desc'><p>type of the protected field</p>\n</div></li></ul></div></li></ul></div></li><li><span class='pre'>mandatoryFields</span> : Object[]<div class='sub-desc'><p>(optional) fields which must be defined in the templateSord or mapping. Throws an exception if one of these fields is missing. (see GetSetInstructions</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>id</span> : String<div class='sub-desc'><p>name of the mandatory field</p>\n</div></li><li><span class='pre'>type</span> : String|\"GRP\"|\"MAP\"|\"WFMAP\"|\"FORMBLOB\"<div class='sub-desc'><p>type of the mandatory field</p>\n</div></li></ul></div></li></ul></div></li></ul></div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-source' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-cfg-source' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-cfg-source' class='name expandable'>source</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Defines, which sord should be used as a data source for setting data on the target sord ...</div><div class='long'><p>Defines, which sord should be used as a data source for setting data on the target sord</p>\n<ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>objId/ARCPATH/GUID of sord to use as data source. If \"fromParams\" is defined, the objId parameter will be used as the value (e.g. in workflow nodes).</p>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>flowId of the sord (optional) if workflow fields of data source should be available. If \"fromParams\" is defined, the flowId parameter will be used as the value (e.g. in workflow nodes).</p>\n</div></li><li><span class='pre'>templateSord</span> : String<div class='sub-desc'><p>(optional) a templateSord which can be used as data source instead of an objId. Either templateSord or objId must be defined!</p>\n</div></li><li><span class='pre'>fromService</span> : Object<div class='sub-desc'><p>(optional) defines a service which must return an Object containing an <code>objId</code>(, <code>flowId</code>) or <code>templateSord</code></p>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>IX-RF name</p>\n</div></li><li><span class='pre'>template</span> : Boolean (optional)<div class='sub-desc'><p>(optional) When true then <code>source.fromService.params</code> will be resolved by Handlebar renderer. Currently only the Id (objId or the id \"fromParams\") is loaded into the context</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'><p>(optional) argument which will be passed to the defined service</p>\n<p>Defaults to: <code>{}</code></p></div></li></ul></div></li></ul></div></div></div><div id='cfg-target' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-cfg-target' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-cfg-target' class='name expandable'>target</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) Defines the sord, on which the data will be set ...</div><div class='long'><p>(optional) Defines the sord, on which the data will be set</p>\n<ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>objId/ARCPATH/GUID of folder to put created sord in. If \"fromParams\" is defined, the objId parameter will be used as the value (e.g. in workflow nodes).</p>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>flowId of the sord (optional) if workflow fields of data source should be available. If \"fromParams\" is defined, the flowId parameter will be used as the value (e.g. in workflow nodes).</p>\n</div></li><li><span class='pre'>fromService</span> : Object<div class='sub-desc'><p>(optional) defines a service which must return an Object containing an <code>objId</code> (or <code>path</code> not implemented yet, see above) definition</p>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>IX-RF name</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'><p>(optional) argument which will be passed to the defined service</p>\n<p>Defaults to: <code>{}</code></p></div></li></ul></div></li><li><span class='pre'>startWorkflow</span> : Object<div class='sub-desc'><p>(optional) starts a workflow on the target sord before setting data</p>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>workflow template name</p>\n</div></li><li><span class='pre'>title</span> : String (optional)<div class='sub-desc'><p>(optional) specifies the workflow-title</p>\n<p>Defaults to: <code>&quot;Workflow&quot;</code></p></div></li><li><span class='pre'>concluding</span> : Boolean (optional)<div class='sub-desc'><p>(optional) if set to true, the workflow will be startet after all values have been set. Hence, no WF-fields can be set</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-_setParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-property-_setParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-property-_setParams' class='name expandable'>_setParams</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-determineTarget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-method-determineTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-method-determineTarget' class='name expandable'>determineTarget</a>( <span class='pre'>tgt</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tgt</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-finalizeGeneratorParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-method-finalizeGeneratorParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-method-finalizeGeneratorParams' class='name expandable'>finalizeGeneratorParams</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-parseOptions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-method-parseOptions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-method-parseOptions' class='name expandable'>parseOptions</a>( <span class='pre'>opts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>opts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-pepareSetParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-method-pepareSetParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-method-pepareSetParams' class='name expandable'>pepareSetParams</a>( <span class='pre'>target, entries</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>entries</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-prepareSource' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-method-prepareSource' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-method-prepareSource' class='name expandable'>prepareSource</a>( <span class='pre'>src</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>src</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of function modules' process. ...</div><div class='long'><p>Implementation of function modules' process.\nThis function must be implemented by the child class and should contain the logic of the function module.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div><div id='method-startWorkflowOn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-method-startWorkflowOn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-method-startWorkflowOn' class='name expandable'>startWorkflowOn</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-storeResult' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-method-storeResult' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-method-storeResult' class='name expandable'>storeResult</a>( <span class='pre'>target, fieldDef</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>fieldDef</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_function_FillSord' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-static-method-RF_sol_function_FillSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-static-method-RF_sol_function_FillSord' class='name expandable'>RF_sol_function_FillSord</a>( <span class='pre'>Execution, args</span> ) : Object<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n<ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>objId of the sord which has been written to</p>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>(optional) flowId, if a workflow has been started on the sord</p>\n</div></li></ul></div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.FillSord'>sol.common.ix.functions.FillSord</span><br/><a href='source/sol.common.ix.functions.FillSord.html#sol-common-ix-functions-FillSord-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.FillSord-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});